*** Table 7:  Evidence from Northern Newspapers: Event-Study Design

cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 


*** OPEN NEWSPAPERS dataset 
use  "$data/main_newspapers.dta", clear

egen cst=group(statefip countyicp)
sort cst week keyword_victim keyword_place


gen POST=0
replace POST=1 if week>-1

foreach i in ///
LD_Z_p40  LD_fr_black D6040_fr_black Z_40to60_p40 fr_black_40 D_fr_black_in40 D_fr_black_in50 Z_p40_in40 Z_p40_in50 {
    
gen `i'_P=`i'*POST

}
.

egen stateweek=group(statefip week)
egen keyword_joint=group(victim_id  place_id)

compress

distinct cst //492 counties for which we have np data 

**************************************************************
cd "$output"

 
// Panel A: 1940-1960

* col. 1
ivreghdfe any_mention (D6040_fr_black_P=Z_40to60_p40_P) POST  ///
 [aw=totpop_40] , a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using Table7_A.xls, excel nocon replace ///
keep (D6040_fr_black_P) dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X, Sample, 1940+, Weeks, -4 to +26)


* col. 2
ivreghdfe any_mention (D6040_fr_black_P=Z_40to60_p40_P) POST ///
 [aw=totpop_40] if year<1945, a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using  Table7_A.xls, excel nocon append ///
keep  (D6040_fr_black_P)  dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X, Sample, 1940-1944, Weeks, -4 to +26)

* col. 3
ivreghdfe any_mention (D6040_fr_black_P=Z_40to60_p40_P) POST ///
 [aw=totpop_40] if year>1944, a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using  Table7_A.xls, excel  nocon append ///
keep (D6040_fr_black_P)  dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X,  Sample, 1945+, Weeks, -4 to +26)


* col. 4 
ivreghdfe any_mention (D6040_fr_black_P=Z_40to60_p40_P) POST  ///
[aw=totpop_40] if year>1949 , a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using Table7_A.xls, excel nocon append ///
keep (D6040_fr_black_P)  dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X, Sample, 1950+, Weeks, -4 to +26)


* col. 5
ivreghdfe any_mention (D6040_fr_black_P=Z_40to60_p40_P) POST  ///
 [aw=totpop_40] if year>1954 , a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using  Table7_A.xls, excel  nocon append ///
keep ( D6040_fr_black_P)  dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X, Sample, 1955+, Weeks, -4 to +26)


* col. 6
ivreghdfe any_mention (D6040_fr_black_P=Z_40to60_p40_P) POST  ///
 [aw=totpop_40] if year>1959 , a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using  Table7_A.xls, excel  nocon append ///
keep (D6040_fr_black_P)  dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X, Sample, 1955+, Weeks, -4 to +26)



// Panel B/1: 1940s-->50s

* col. 1 
ivreghdfe any_mention (D_fr_black_in40_P=Z_p40_in40_P)  ///
[aw=totpop_40] if year<1945 , a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using Table7_B.xls, excel   nocon replace ///
keep ( D_fr_black_in40_P)  dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X, Sample, 1940-1944, Weeks, -4 to +26)

* col. 2
ivreghdfe any_mention  (D_fr_black_in40_P=Z_p40_in40_P)      [aw=totpop_40] if year>1944 , a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using  Table7_B.xls, excel   nocon append ///
keep ( D_fr_black_in40_P)  dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X, Sample, 1945+, Weeks, -4 to +26)


*col. 3
ivreghdfe any_mention  (D_fr_black_in40_P=Z_p40_in40_P)      [aw=totpop_40] if year>1949 , a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using  Table7_B.xls, excel nocon append ///
keep ( D_fr_black_in40_P )  dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X, Sample, 1950+, Weeks, -4 to +26)



// Panel B/2: 1950s-->60s

* col. 4
ivreghdfe any_mention  (D_fr_black_in50_P=Z_p40_in50_P)  ///
 [aw=totpop_40] if year<1950 , a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using  Table7_B.xls, excel nocon append ///
keep ( D_fr_black_in50_P)  dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X, Sample, 1940-49, Weeks, -4 to +26)


* col. 5 
ivreghdfe any_mention  (D_fr_black_in50_P=Z_p40_in50_P)   ///
 [aw=totpop_40] if year>1954 , a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using  Table7_B.xls, excel nocon append ///
keep ( D_fr_black_in50_P)  dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X, Sample, 1955+, Weeks, -4 to +26)


* col. 6 
ivreghdfe any_mention  (D_fr_black_in50_P=Z_p40_in50_P)  ///
 [aw=totpop_40] if year>1959 , a(cst keyword_joint stateweek) cluster(cst)
local F=e(widstat)
outreg2 using Table7_B.xls, excel nocon append ///
keep ( D_fr_black_in50_P )  dec(3) addstat( "F-stat", `F')  ///
addtext(County FE, X, Episode FE, X, State-week FE, X, Sample, 1950+, Weeks, -4 to +26)

